#ifndef CE2_RSA_KG_H
#define CE2_RSA_KG_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 *  Object %CE2_RSA_KG.H    : %
 *  State           :  %state%
 *  Creation date   :  Sun Mar 06 15:55:45 2005
 *  Last modified   :  %modify_time%
 */
/** @file
 *  \brief This module defines the API for key-pair generation functions
 *
 *  \version CE2_RSA_KG.h#1:incl:1
 *  \author Discretix
 *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
 *           All Rights reserved
 */

/**
****************************************************************
* Function Name: 
*  CE2_RSA_KG_GenerateKeyPair
*
* Inputs:
*  @param PubExp_ptr [in] - The pointer to the public exponent (public key);
*  @param PubExpSizeInBytes [in] - The public exponent size in bits;
*  @param KeySize [in] - The size of the key, in bits;
*         Supported sizes are all 256 multiples between 512 - 2048.
*  @param UserPrivKey_ptr [out] - A pointer to the private key structure;
*         This structure is used as input to the CE2_RSA_PRIM_Decrypt API.
*  @param UserPubKey_ptr  [out] - A pointer to the public key structure.
*         This structure is used as input to the CE2_RSA_PRIM_Encrypt API.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_EXPONENT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_MODULUS_SIZE,
*     - CE2_RSA_INVALID_EXPONENT_SIZE.
*
* \brief \b
* Description:
*  CE2_RSA_KG_GenerateKeyPair generates a Pair of public and
*  private keys on non CRT mode.
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_Build_PubKey
*     to generates a Pair of public and private keys on
*     non CRT mode key with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_KG_GenerateKeyPair(DxUint8_t               *PubExp_ptr,
                                        DxUint16_t               PubExpSizeInBytes, 
                                        DxUint32_t               KeySize,
                                        CE2_RSAUserPrivKey_t *UserPrivKey_ptr,
                                        CE2_RSAUserPubKey_t  *UserPubKey_ptr);

/**
****************************************************************
* Function Name: 
*  CE2_RSA_KG_GenerateKeyPairCRT
*
* Inputs:
*  @param PubExp_ptr [in] - The pointer to the public exponent (public key);
*  @param PubExpSizeInBytes [in] - The public exponent size in bits;
*  @param KeySize [in] - The size of the key, in bits;
*         Supported sizes are all 256 multiples between 512 - 2048
*  @param UserPrivKey_ptr [out] - A pointer to the private key structure;
*         This structure is used as input to the CE2_RSA_PRIM_Decrypt API.
*  @param UserPubKey_ptr  [out] - A pointer to the public key structure.
*         This structure is used as input to the CE2_RSA_PRIM_Encrypt API.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_EXPONENT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_INVALID_MODULUS_SIZE,
*     - CE2_RSA_INVALID_EXPONENT_SIZE.
*
* \brief \b
* Description:
*  CE2_RSA_KG_GenerateKeyPairCRT generates a Pair of public and
*  private keys on CRT mode.
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RSA_Build_PubKey
*     to build private key with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RSA_KG_GenerateKeyPairCRT(DxUint8_t    *PubExp_ptr,
                                           DxUint16_t           PubExpSizeInBytes, 
                                           DxUint32_t           KeySize,
                                           CE2_RSAUserPrivKey_t *UserPrivKey_ptr,
                                           CE2_RSAUserPubKey_t  *UserPubKey_ptr);

/**
****************************************************************
* Function Name: 
*  CE2_RSA_KG_GenerateKeyPairFull
*
* Inputs:
*  @param PubExp_ptr [in] - The pointer to the public exponent (public key);
*  @param PubExpSizeInBytes [in] - The public exponent size in bits;
*  @param KeySize [in] - The size of the key, in bits;
*         Supported sizes are all 256 multiples between 512 - 2048
*  @param UserPrivKeyFull_ptr [out] - A pointer to the private key structure;
*  @param UserPubKey_ptr  [out] - A pointer to the public key structure.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_EXPONENT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_KEY_GEN_DATA_STRUCT_POINTER_INVALID,
*     - CE2_RSA_INVALID_MODULUS_SIZE,
*     - CE2_RSA_INVALID_EXPONENT_SIZE.
*
* \brief \b
* Description:
*  CE2_RSA_KG_GenerateKeyPairFull generates a Pair of public and
*  private keys with full information (CRT and non CRT private key). 
*  CE2_RSA_KG_GenerateKeyPairFull function duplicate 
*  CE2_RSA_KG_GenerateKeyPairCRT function (CRT key contains non CRT key). 
*
* \b
* Algorithm:
*
***************************************************************/
#define CE2_RSA_KG_GenerateKeyPairFull CE2_RSA_KG_GenerateKeyPairCRT 

#ifdef __cplusplus
}
#endif

#endif /* CE2_RSA_KG_H */
